'use strict';

/**
 * @module engine
 * @copyright Jinhua Huang <wolley.huang@gmail.com>
 *
 * Usage:
 *   const engine = require('engine');
 *   engine.on('init', func);
 *   engine.on('start', func);
 *   engine.on('stop', func);
 *   engine.on('new', func);
 *   engine.on('change', func);
 *   engine.on('message', func);
 *   engine.on('trainings', func);
 *   engine.on('products', func);
 *   engine.on('release', func);
 *   engine.on('productionStart', func);
 *   engine.on('productionStop', func);
 *   engine.init(packageName);
 *   engine.configTrainings(file);
 *   engine.getTrainings();
 *   engine.start(options);
 *     options { baudRate, usbOnly, usbAutoEnable, enableOnce, disabledGroups }
 *   engine.enable(path);
 *   engine.stop();
 *   engine.getProducts();
 *   engine.release(options);
 *     options { product, eraseAll, eraseAllOnly, output }
 *   engine.productionStart();
 *   engine.productionStop();
 */

const EventEmitter = require('events');
const Binding = require('bindings')('addon');
const fs = require('fs');

class AbootEngine extends EventEmitter {

  static getInstance() {
    AbootEngine.instance = new AbootEngine();
    return AbootEngine.instance;
  }

  constructor() {
    super();
    this.binding = Binding;
    this.binding.register(this.emit.bind(this));
  }

  init(packageName) {
    let param = {
      "path": packageName
    };
    this.binding.init(JSON.stringify(param));
  }

  start(options) {
    this.binding.start(JSON.stringify(options));
  }

  stop() {
    this.binding.stop();
  }

  getProducts(options) {
    this.binding.getProducts(JSON.stringify(options));
  }

  release(options) {
    this.binding.release(JSON.stringify(options));
  }

  enable(path) {
    let param = {
      "path": path
    };
    this.binding.enable(JSON.stringify(param));
  }

  configTrainings(file) {
    let contents = fs.readFileSync(file, 'utf8');
    this.binding.configTrainings(contents);
  }

  getTrainings() {
    this.binding.getTrainings();
  }

  productionStart() {
    this.binding.productionStart();
  }

  productionStop() {
    this.binding.productionStop();
  }

}

module.exports = AbootEngine.getInstance();
